# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package SR_cli_display_utils;
#"@(#)30   1.23   src/rsct/registry/cli/pm/SR_cli_display_utils.pm.perl, srcli, rsct_rpyxh, rpyxht1f3 3/3/01 22:46:15"
######################################################################
#                                                                    #
# Package: SR_cli_display_utils.pm                                   #
#                                                                    #
# Description:                                                       #
#   This package contains common display subroutines for the PERL    #
#   System Registry CLI commands.                                    #
#                                                                    #
# Subroutines Exported:                                              #
#                                                                    #
#     Note: all routines display to STDOUT                           #
#     create_display    - construct array from table data suitable   #
#                         for use in any display type, then display  #
#                         the array data                             #
#                                                                    #
#  The first set of examples are for using the common create_display #
#  function to format the table data.                                #
#                                                                    #
#    To create a delimited display, where the delimiter is stored    #
#    in $Opt_Delimiter:                                              #
#    create_display($Result_table, $Table_name, "delim",             #
#               $Opt_Delimiter, $Opt_No_Header,                      #
#               $Opt_Print_System_Columns);                          #
#                                                                    #
#    To create long form output display:                             #
#    ($Opt_Delimiter here must contain a value or NULL)              #
#    create_display($Result_table, $Table_name, "long",              #
#               $Opt_Delimiter, $Opt_No_Header,                      #
#               $Opt_Print_System_Columns);                          #
#                                                                    #
#    To create file format output:                                   #
#    ($Opt_Delimiter here must contain a value or NULL)              #
#    create_display($Result_table, $Table_name, "file",              #
#               $Opt_Delimiter, $Opt_No_Header,                      #
#               $Opt_Print_System_Columns);                          #
#                                                                    #
#    To create column output:                                        #
#    ($Opt_Delimiter here must contain a valueor NULL)               #
#    create_display($Result_table, $Table_name, "column",            #
#               $Opt_Delimiter, $Opt_No_Header,                      #
#               $Opt_Print_System_Columns);                          #
#                                                                    #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   /usr/sbin/rsct/msgmaps/srcli.srcli.map - message mapping         #
#                                                                    #
# Outputs:                                                           #
#   stdout - common informational messages that get displayed.       #
#          - all display output.                                     #
#   stderr - common error messages that get displayed.               #
#                                                                    #
# External References:                                               #
#   Commands:                                                        #
#   Extensions:  SR.pm, SRrc.pm, CT.pm                               #
#   Perl Modules: SR_cli_utils.pm - get_table_metadata               #
#                                   free_table_metadata              #
#                                   get_fields_by_index              #
#                                   make_value_struct_t              #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000929 HGJ 38317: Initial delivery.                              #
#                                                                    #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw( create_display hex2bin sd_pattern_to_string );

use lib "/usr/sbin/rsct/pm";
use locale;

use CT::CT qw(:ct_data_type_t);
use CT_cli_data_type_utils qw(data_type_to_string);
use CT_cli_display_utils qw(
    set_display
    convert_value
);

use CT::SR qw(:sr_qualifier_t);
use SR_cli_utils qw(
    get_table_metadata
    free_table_metadata
    make_value_struct_t
    get_fields_by_index
);
use SR_cli_rc qw(:return_codes);


#--------------------------------------------------------------------#
# Global Variables                                                   #
#--------------------------------------------------------------------#

$CTDIR ="/usr/sbin/rsct";             # Cluster directory path
#$CTBINDIR ="$CTDIR/bin";             # Cluster Bin directory path


$ENV{'MSGMAPPATH'}="$CTDIR/msgmaps";  # Msg map path for $LSMSG

# TODO: Uncatalogued verbose/trace statements in this code are trace
# statements that will be converted when the facility is made
# available to the SR (Feature 48401)


#--------------------------------------------------------------------#
# Begin Exported Subroutines (with @EXPORT_OK, -> on demand).        #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# create_display:                                                    #
#   Write table data to STDOUT in column, long, file, or delimited   #
#   format. Calls either column_display, long_display, or            #
#   delim_display. Calls CT::SR::get_table_metadata to grab column   #
#   types in order to extract data to display.                       #
#                                                                    #
# Parameters:                                                        #
#   $table        - table handle returned from call to CT::SR::select#
#   $table_name   - name of the table to be printed                  #
#   $type         - either column, long or delim                     #
#   $delimiter    - delimiter to use, if given                       #
#   $no_header    - (boolean) header suppression flag                #
#   $print_sy_cols- (boolean) print system qualified colums          #
#                   ie RowChangeCounter                              #
#   $print_sy_key - (boolean) print table key                        #
#   $columns_to_print - list of column names to be displayed         #
#                                                                    #
# Returns:                                                           #
#   $local_rc     - 0 if command completes successfully              #
#                                                                    #
# Globals Used:                                                      #
#   $main::Trace - to print trace information if requested           #
#--------------------------------------------------------------------#
sub create_display 
{
# Get input parameters
my $table = shift;
my $table_name = shift;
my $type = shift;
my $delimiter = shift;
my $no_header = shift;
my $print_sy_cols = shift;
my $print_key = shift;
my $columns_to_print = shift;

# Set up variables needed
my @columns = ();
my $row_index = 0;
my $col_index = 0;
my $col_count = 0;
my $local_rc = 0;
my $TRUE = 1;
my $FALSE = 0;
my $check_for_key = $FALSE;
my @column_names = ();
my ($row_header_string, $input_results, $column_list_used);
# $results;

$main::Trace && 
  print STDERR "Entered SR_cli_display_utils::create_display(\"$type\")\n";

my $metadata;
($local_rc, $metadata) = get_table_metadata($table);

my $row_count = $metadata->getNumRows();
my $col_defs = $metadata->getColumnDefs();

# Flag if the primary key needs to be scanned for if it to be omitted
# 'join' means it's a from joinsr, and that all the
# columns are going to be printed, including the key.
# TODO: this will have to be changed in conjunction with the
# srjoin command

if ((defined $columns_to_print->[0]) and 
    ($columns_to_print->[0] ne "join")) { 
    $check_for_key = $TRUE; 
}

# Input file format never prints the system columns
if ($type eq "file") { $print_sy_cols = 0; }

# Define extension variables needed to prepare data for display
# Try to be exact about how many spaces to allocate

# TODO: legacy statement left in here for coexistence until
# the builds get back lined up again.. 04/24 HGJ.

if ((defined $columns_to_print->[0]) and 
    ($columns_to_print->[0] ne '*')) {
    @column_names = @$columns_to_print;
}

# This is here just in case the RowChangeCounter isn't displayed
# in that case, the only accurate count of columns to be processed
# comes from the previous loop
$col_count = $col_index;

# Set keyword for System Registry Input File in the corner spot
if ($type eq "file") { $columns[0][0] = "RowData"; }

# Set up the value_struct_t structure to be fed to get_fields_by_index
($local_rc, $input_results, $column_list_used) = 
    make_value_struct_t($col_defs, \@column_names, $print_sy_cols);

$col_index = 1;
foreach $name (@$column_list_used) {
    $columns[0][$col_index++] = $name;
}

# Count of columns used in grabbing data from get_fields_by_index
$col_count = $col_index - 1;
$col_index = 0;

# Iterate down the table and get the values, putting them into
# the output array
while (($local_rc == 0 ) && ( $row_index < ($row_count) )) {

    my $input_result_holder  = $input_results;

    ($local_rc, $results) = get_fields_by_index($table, $row_index,
                            $column_list_used, $input_result_holder);
                            
    # Set up the row header string
    $row_header_string = "row $row_index:";
    $row_index++;

    # Set up row header information
    $columns[$row_index][0] = $row_header_string;

    while ($col_index < $col_count) {
        # Take each entry from the results array and set it
        # into the correct array structure:

        my $result_value = $results->[0][$col_index];
        my $result_type = $results->[1][$col_index];
        $columns[$row_index][$col_index+1] =
            convert_value($result_type,$result_value);
#            convert_value($results->[1][$col_index],$results->[0][$col_index], $col_defs->[$col_index]->{sd_defn});
        $col_index++;
    }
    $col_index = 0;

    undef $input_result_holder;

} # end while ($local_rc == 0)

set_display($type, $no_header, $row_count, $col_count + 1, \@columns, 
                        $delimiter, $table_name);


$local_rc = free_table_metadata($metadata);
#undef ($metadata);

$main::Trace && 
  print STDERR "Leaving SR_cli_display_utils::create_display($local_rc)\n";

return $local_rc;
}   # end create_display


#--------------------------------------------------------------------#
# hex2bin:                                                           #
#  Converts a string assumed to contain hex characters to a packed   #
#  string using pack. Spaces in the string are removed. Length of    #
#  the packed string is returned with the string.                    #
#                                                                    #
# Paramaters:                                                        #
#   $input_string   hexadecimal string to be converted               #
#                                                                    #
# Returns:                                                           #
#   $packed_length  length of converted string                       #
#   $output_string  converted string                                 #
#                                                                    #
# Global Variables:                                                  #
#   $main::Verbose Turns verbose mode on                             #
#--------------------------------------------------------------------#
sub hex2bin 
{
# There is probably a better way to to this, but this is the best
# for now

# Grab input parameters
my $input_string = shift;

#print "hex input: $input_string..\n";
$input_string =~ s/ //g;
#print "hex input: $input_string..\n";

# This will at least make the bit string an even number so the
# pack/unpack sequence doesn't right pad as it appears to like
# to if it is given an uneven number of bits

if (length($input_string)%2) { 
    $input_string = "0".$input_string;
}
$packed_length = length($input_string)/2;
#print "hex input: $input_string..\n";
#print "packed length: $packed_length\n";


# Convert the string to binary format using pack
# The '*' will chew up as many characters as can be found
# up to a null. Since the input is a string (PV) this is
# safe. To unpack this value, the number of characters
# needs to be specified otherwise you risk getting garbage
# on the end of the unpacked string.
#$output_string = pack("H${input_length}", $input_string);
$output_string = pack("H*", $input_string);

return($packed_length, $output_string);
}   # end hex2bin


#--------------------------------------------------------------------#
# sd_pattern_to_string:                                              #
#   TODO: header for this sub.                                       #
#   Note: This sub may not be used - is kept here in case a short    #
#   form of the sd definition will be displayed to the screen ever.  #
#--------------------------------------------------------------------#
sub sd_pattern_to_string 
{
my $sd_defn = shift;

my $local_rc = 0;
my $index = 0;

my $name_array = $sd_defn->[0];
my $type_array = $sd_defn->[1];
my $count = scalar(@$name_array);
my $output_string = "";

#printf "$count entries\n";
while ($index < $count) {
    #pattern is {name,type},{name,type},...
    $output_string = $output_string ."{". $name_array->[$index].",".
             data_type_to_string($type_array->[$index]). "},";
    $index++;
}

chop $output_string;
$output_string = '['.$output_string.']';

#print "output sd defn: $output_string\n";
return $output_string;
}   # end sd_pattern_to_string


#--------------------------------------------------------------------#
# End Exported Subroutines (with @EXPORT_OK, -> on demand).          #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# End of File                                                        #
#--------------------------------------------------------------------#
